﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace PerformanceTesting
{
    [Serializable]
    public class Test : ITest
    {
        public string Address { get; set; }

        public int Clients { get; set; }

        public int ClientStartDelay { get; set; }

        public List<Step> Steps { get; set; }

        public Test() 
        {
            Steps = new List<Step>();
        }

        public void RunSteps(IDialog dialog, Barrier[] stepBarriers)
        {
            int i = 0;
            foreach (Step step in Steps.OrderBy(step => step.Index))
            {
                dialog = step.Run(dialog, stepBarriers[i]);
                Interlocked.Increment(ref i);                
            }
        }
    }
}